$.fn.TheCoreElementsMatrix_attach = function(params)
{
    var b;
    var parent_div = this;

    var tab_switcher = $('<div class="TheCoreElementsMatrix tab_switcher"><hr></div>');
    tab_switcher.appendTo(parent_div);

    var oper = $('<div class="TheCoreElementsMatrix tab_oper"></div>');
    oper.appendTo(parent_div);

    b = $('<div class="TheCoreElementsMatrix tab_switch CONF" title="Configuration"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsMatrix tab_switch VIDEO" title="Video"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsMatrix tab_switch DBG" title="Debugging"></div>');
    b.appendTo(tab_switcher);

    tab_switcher.delegate("div.TheCoreElementsMatrix.tab_switch", "mousedown", function()
    {
        tab_switcher.find('div.TheCoreElementsMatrix.tab_switch').removeClass('active');
        $(this).addClass('active');

        oper.empty();
        oper.remove();
        oper = $('<div class="TheCoreElementsMatrix tab_oper"></div>');
        oper.appendTo(parent_div);

        if($(this).hasClass('CONF'))
        {
            console.log("TheCoreElementsMatrix.tab_switch: CONF");
            oper.TheCoreElementsMatrix_Labels_attach(params);
        }
        else if($(this).hasClass('VIDEO'))
        {
            console.log("TheCoreElementsMatrix.tab_switch: VIDEO");
            oper.TheCoreElementsMatrix_control_attach(params);
        }
        else if($(this).hasClass('DBG'))
        {
            console.log("TheCoreElementsMatrix.tab_switch: DBG");
            oper.TheCoreElementsMatrix_DBG_attach(params);
        };
    });

    tab_switcher.find('div.TheCoreElementsMatrix.tab_switch.VIDEO').trigger('mousedown');
};


$.fn.TheCoreElementsMatrix_Labels_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    parent_div.delegate("button.TheCoreElementsMatrix.LABELS.SAVE", "click", function()
    {
        var table = parent_div.find('table.TheCoreElementsMatrix.LABELS');
        var inputs_cnt = table.attr('inputs-cnt');
        var outputs_cnt = table.attr('outputs-cnt');
        var inputs = Array(), outputs = Array();

        console.log("inputs_cnt=" + inputs_cnt + ", outputs_cnt=" + outputs_cnt);
        for(var i = 0; i < inputs_cnt; i++) inputs[i] = "";
        for(var i = 0; i < outputs_cnt; i++) outputs[i] = "";

        table.find('tr.VALUES').each(function(index)
        {
            var idx = parseInt($(this).attr('idx'));

            if(idx < inputs_cnt)
                inputs[idx] = $(this).find("input.INPUT").val();

            if(idx < outputs_cnt)
                outputs[idx] = $(this).find("input.OUTPUT").val();
        });

        $.post
        (
            'TheCoreElementsMatrix.SetLabels.php',
            {
                'xmlrpc_port' : params['port'],
                'inputs': inputs,
                'outputs': outputs,
            }
        )
        .done
        (
            function(curr)
            {
                load();
            }
        );
    });

    function load()
    {
        $.getJSON
        (
            'TheCoreElementsMatrix.GetLabels.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetLabels:" + JSON.stringify(curr));

            if((typeof curr.inputs === 'undefined') || (typeof curr.outputs === 'undefined'))
            {
                console.log("Error");
            }
            else
            {
                console.log("will apply labels");

                parent_div.empty();

                var btn = $('<button class="TheCoreElementsMatrix LABELS SAVE"> SAVE </button>');
                btn.appendTo(parent_div);

                var table = $('<table class="TheCoreElementsMatrix LABELS"></table>');
                table.appendTo(parent_div);
                table.attr('inputs-cnt', curr.inputs.length);
                table.attr('outputs-cnt', curr.outputs.length);

                var thead = $('<thead><tr><th class="IDX">#</th><th class="INPUT">INPUTS</th><th class="IDX">#</th><th class="OUTPUT">OUTPUT</th></tr></thead>');
                table.append(thead);

                var tbody = $('<tbody></tbody>');
                table.append(tbody);

                var l = (curr.inputs.length > curr.outputs.length) ? curr.inputs.length : curr.outputs.length;

                for(var i = 0; i < l; i++)
                {
                    var tr = $('<tr class="VALUES"><td class="IDX">' + i + '</td><td><input type="text" size="16" class="INPUT"></td><td class="IDX">' + i + '</td><td><input type="text" size="16" class="OUTPUT"></td></tr>');
                    tr.attr('idx', i);

                    if(i < curr.inputs.length)
                        tr.find('.INPUT').val(curr.inputs[i]);

                    if(i < curr.outputs.length)
                        tr.find('.OUTPUT').val(curr.outputs[i]);

                    tbody.append(tr);
                };
            };
        })
        .fail(function(msg)
        {
        });
    }

    load();
}

$.fn.TheCoreElementsMatrix_DBG_attach = function(params)
{
    var parent_div = this;
    var amend = -1;
    var f_exit = 0;

    parent_div.bind('destroyed', function() {
        console.log("f_exit = 1");
        f_exit = 1;
    });

    var state_area = $('<div class="TheCoreElementsMatrix DBG state_area">pool size <span class="pool_size"></span>, pool free <span class="pool_free"></span></div>');
    state_area.appendTo(parent_div);

    var table = $('<table class="TheCoreElementsMatrix"></table>');
    table.appendTo(parent_div);

    var thead = $('<thead><tr><th>PID</th><th>USED</th><th>NAME</th></tr></thead>');
    table.append(thead);

    var tbody = $('<tbody></tbody>');
    table.append(tbody);

    function GetDbg(retry_delay)
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsMatrix.GetDbg.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetDbg:" + JSON.stringify(curr));

            tbody.empty();

            if(!(typeof curr.apps === 'undefined'))
            {
                state_area.find('span.pool_size').text(curr.cnt);
                state_area.find('span.pool_free').text(curr.frames);

                for(var i = 0; i < curr.apps.length; i++)
                {
                    var tr = $('<tr><td class="pid"></td><td class="cnt"></td><td class="name"></td></tr>');
                    tbody.append(tr);

                    tr.find('.pid').text(curr.apps[i]['pid']);
                    tr.find('.cnt').text(curr.apps[i]['cnt']);
                    tr.find('.name').text(curr.apps[i]['name']);
                };

            }
            else
            {
                amend = -1;
                state_area.find('span.pool_size').text('?');
                state_area.find('span.pool_free').text('?');
            }

            if(retry_delay > 0)
                window.setTimeout(function() { GetDbg(retry_delay); }, retry_delay);
        })
        .fail(function(msg)
        {
            amend = -1;
            if(retry_delay > 0)
                window.setTimeout(function() { GetDbg(retry_delay); }, 4 * retry_delay);
        });
    };
    GetDbg(1000);
}


$.fn.TheCoreElementsMatrix_control_attach = function(params)
{
    var parent_div = this;
    var amend = -1;
    var f_exit = 0;

    parent_div.bind('destroyed', function() {
        console.log("f_exit = 1");
        f_exit = 1;
    });

    var table_head = $('<div class="TheCoreElementsMatrix table_head"><table border="0"><tr><td class="button_take"></td><td class="button_clear"></td></tr></table></div>');
    table_head.appendTo(parent_div);
    {
        var btn;

        btn = $('<div class="TheCoreElementsMatrix oper_ctl oper_ctl_TAKE"><span class="index"></span><br><span class="title">TAKE</span></div>');
        btn.addClass('passive');
        btn.appendTo(table_head.find('td.button_take'));

        btn = $('<div class="TheCoreElementsMatrix oper_ctl oper_ctl_CLEAR"><span class="index"></span><br><span class="title">CLEAR</span></div>');
        btn.addClass('passive');
        btn.appendTo(table_head.find('td.button_clear'));
    };

    var table = $('<table class="TheCoreElementsMatrix"></table>');
    table.appendTo(parent_div);

    function BuildGrid(conf)
    {
        for(var j = 0; j < params.outputs; j++)
        {
            if(conf.outputs[j] == "")
                continue;

            var tr = $('<tr class="TheCoreElementsMatrix"></tr>');

            function add_output_btn(kls)
            {
                var td = $('<td class="TheCoreElementsMatrix output"></td>');
                td.attr('output-idx', j);

                var btn = $('<div class="TheCoreElementsMatrix output"><span class="index"></span><br><span class="title"></span></div>');
                btn.attr('output-idx', j);
                btn.find('.index').text(j);

                btn.appendTo(td);

                td.appendTo(tr);

                btn.addClass(kls);
            };

            add_output_btn('left');

            for(var i = 0; i < params.inputs; i++)
            {
                if(conf.inputs[i] == "")
                    continue;

                var td = $('<td class="TheCoreElementsMatrix input"></td>');
                td.attr('input-idx', i);
                td.attr('output-idx', j);

                var btn = $('<div class="TheCoreElementsMatrix input"><span class="index"></span><br><span class="title"></span></div>');
                btn.attr('input-idx', i);
                btn.attr('output-idx', j);
                btn.addClass('passive');

                if(params['buttons_color'] === undefined)
                    btn.addClass('red');
                else
                    btn.addClass(params['buttons_color']);

                btn.find('.index').text(i);
//                btn.find('.title').html('MIX0<br>DSK1');

                btn.appendTo(td);

                td.appendTo(tr);
            };

            add_output_btn('right');

            tr.appendTo(table);
        };
    };

    function GetStat(retry_delay)
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsMatrix.GetStat.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));

            if(!(typeof curr.amend === 'undefined'))
            {
                console.log("amend=" + amend + ", curr.amend=" + curr.amend);
                if(amend < curr.amend)
                {
                    console.log("will apply changes");
                    amend = curr.amend;

                    parent_div.find("div.TheCoreElementsMatrix.input").each(function(index)
                    {
                        var input_idx = parseInt($(this).attr('input-idx'));
                        var output_idx = parseInt($(this).attr('output-idx'));
                        var v = curr.inputs_src[output_idx];

                        if(input_idx != v)
                        {
                            $(this).addClass('passive');
                            $(this).removeClass('active');
                        }
                        else
                        {
                            $(this).addClass('active');
                            $(this).removeClass('passive');
                        };
                    });

                };
            }
            else
            {
                amend = -1;
            }

            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, retry_delay);
        })
        .fail(function(msg)
        {
            amend = -1;
            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, 4 * retry_delay);
        });
    };

    function GetLabels()
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsMatrix.GetLabels.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetLabels:" + JSON.stringify(curr));

            if(!(typeof curr.inputs === 'undefined'))
            {
                console.log("will apply labels");

                BuildGrid(curr);

                parent_div.find("div.TheCoreElementsMatrix.input").each(function(index)
                {
                    var input_idx = parseInt($(this).attr('input-idx'));
                    var input_label = curr.inputs[input_idx];

                    $(this).find('.title').html(input_label.replace("/", "<br>"));

                    if(input_label == "")
                        $(this).parents('td').hide();
                    else
                        $(this).parents('td').show();
                });

                parent_div.find("div.TheCoreElementsMatrix.output").each(function(index)
                {
                    var output_idx = parseInt($(this).attr('output-idx'));
                    var output_label = curr.outputs[output_idx];

                    $(this).find('.title').html(output_label.replace("/", "<br>"));

                    if(output_label == "")
                        $(this).parents('tr').hide();
                    else
                        $(this).parents('tr').show();
                });

                GetStat(1000);
            };
        })
        .fail(function(msg)
        {
        });
    };

    var input_button_tooltip_empty = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';
    var input_button_tooltip_div = $('<div class="TheCoreElementsMatrix input_button_tooltip"><img class="TheCoreElementsMatrix input_button_tooltip"></div>');
        input_button_tooltip_div.appendTo($('body'));
        input_button_tooltip_div.hide();
        input_button_tooltip_div.find('img').attr('src', input_button_tooltip_empty);

    function input_button_tooltip_show(pin)
    {
        if(pin)
            u = "http://" + window.location.hostname + ":89/" + ((pin < 0) ? ('i' + (-pin)) : ('o' + pin)) + '-3-5.jpg';
        else
            u = input_button_tooltip_empty;
        input_button_tooltip_div.find('img').attr('src', u);
        input_button_tooltip_div.show();
    };

    var input_button_tooltip_timer = null;

    parent_div.delegate("div.TheCoreElementsMatrix.input, div.TheCoreElementsMatrix.output",
        "mouseleave", function()
    {
        if(null != input_button_tooltip_timer)
            clearTimeout(input_button_tooltip_timer);
        input_button_tooltip_timer = null;
        input_button_tooltip_div.hide();
        input_button_tooltip_div.find('img').attr('src', input_button_tooltip_empty);
    });

    parent_div.delegate("div.TheCoreElementsMatrix.input, div.TheCoreElementsMatrix.output",
        "mouseover", function(event)
    {
        var input_idx = $(this).attr('input-idx');
        var output_idx = $(this).attr('output-idx');
        var pin = $(this).hasClass('input') ? -input_idx : output_idx;
        var
            x_offset = Math.floor(parseInt($(this).css('width')) / 3),
            y_offset = Math.floor(parseInt($(this).css('height')) / 3),
            x_offset_r = parseInt(input_button_tooltip_div.css('width')),
            y_offset_r = parseInt(input_button_tooltip_div.css('height')),
            y_pos = event.pageY + x_offset,
            x_pos = event.pageX + x_offset;

//        console.log('y_pos=' + y_pos + ', x_pos=' + x_pos + ', x_offset=' + x_offset + ', x_offset_r=' + x_offset_r);

        if((x_pos + x_offset_r) > $(document).width())
            x_pos -= 2 * x_offset + x_offset_r;

        if((y_pos + y_offset_r) > $(window).height())
            y_pos -= 2 * y_offset + y_offset_r;

        console.log('y_pos=' + y_pos + ', x_pos=' + x_pos);

        input_button_tooltip_div.css('left', x_pos + 'px');
        input_button_tooltip_div.css('top', y_pos + 'px');
        if(null == input_button_tooltip_timer)
            input_button_tooltip_timer = setTimeout(input_button_tooltip_show, 500, pin);
    });

    parent_div.delegate("div.TheCoreElementsMatrix.input.passive", "mouseleave", function()
    {
        var input_idx = $(this).attr('input-idx');
        var output_idx = $(this).attr('output-idx');

        parent_div.find("div.TheCoreElementsMatrix.output").each(function(){
            var _output_idx = $(this).attr('output-idx');
            if(output_idx == _output_idx)
                while($(this).hasClass('highlight'))
                    $(this).removeClass('highlight');
        });
    });

    parent_div.delegate("div.TheCoreElementsMatrix.input.passive", "mouseover", function()
    {
        var input_idx = $(this).attr('input-idx');
        var output_idx = $(this).attr('output-idx');

        parent_div.find("div.TheCoreElementsMatrix.output").each(function(){
            var _output_idx = $(this).attr('output-idx');
            if(output_idx == _output_idx)
                $(this).addClass('highlight');
        });
    });

    parent_div.delegate("div.TheCoreElementsMatrix.oper_ctl.active", "click", function()
    {
        /* unhighlight operation control buttons */
        parent_div.find('div.TheCoreElementsMatrix.oper_ctl.active').each(function(){
            $(this).removeClass('active');
            $(this).addClass('passive');
        });

        var take = $(this).hasClass('oper_ctl_TAKE');

        /* process selected button */
        parent_div.find('div.TheCoreElementsMatrix.input.passive.selected').each(function()
        {
            var input_idx = $(this).attr('input-idx');
            var output_idx = $(this).attr('output-idx');

            $(this).removeClass('selected');

            if(take)
            {
                console.log("input setting: input_idx=[" + input_idx + "], output_idx=[" + output_idx + "]");

                $.getJSON
                (
                    'TheCoreElementsMatrix.SetOutput.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'input_idx' : input_idx,
                        'output_idx' : output_idx,
                    }
                )
                .done
                (
                    function(curr)
                    {
                        GetStat(-1);
                    }
                );
            };
        });
    });

    parent_div.delegate("div.TheCoreElementsMatrix.input.passive", "click", function()
    {
        var input_idx = $(this).attr('input-idx');
        var output_idx = $(this).attr('output-idx');

        console.log("input selected: input_idx=[" + input_idx + "], output_idx=[" + output_idx + "]");

        if($(this).hasClass('passive'))
        {
            /* clear previous selection */
            parent_div.find('div.TheCoreElementsMatrix.input.passive.selected').each(function(){
                $(this).removeClass('selected');
            });

            /* setup this crosspoint selected */
            $(this).addClass('selected');

            /* highlight oper ctl buttons */
            parent_div.find('div.TheCoreElementsMatrix.oper_ctl.passive').each(function(){
                $(this).removeClass('passive');
                if(!$(this).hasClass('active'))
                    $(this).addClass('active');
            });
        };
/*
*/
    });
//

    GetLabels();
}
