var CONFIG;
var STATE_CHANNEL_ID;
var STATE_DATE;
var STATE_TIMESTAMP_MS;
var STATE_CHUNKS = [];
var STATE_HLS;
var STATE_CONTS = [];

function build_hls_cont(timestamp_ms)
{
    var cont = undefined;

    var timestamp = Math.round(timestamp_ms / 1000);

    for(var i = 0; i < STATE_CHUNKS.length; i++)
    {
        if(!i || STATE_CHUNKS[i].ts_start != (STATE_CHUNKS[i - 1].ts_start + STATE_CHUNKS[i - 1].ts_dur))
        {
            if(cont !== undefined)
                STATE_CONTS.push(cont);

            cont = {};
            cont['chunk_idx'] = i;
            cont['chunk_cnt'] = 0;
            cont['filename'] = STATE_CHUNKS[i]['filename']
            cont['timestamp'] = STATE_CHUNKS[i]['timestamp']
            cont['ts_dur'] = 0.0;
            cont['ts_start'] = STATE_CHUNKS[i]['ts_start']
            cont['offset'] = STATE_CHUNKS[i].timestamp - timestamp;
        };

        cont['ts_dur'] += STATE_CHUNKS[i].ts_dur;
        cont['chunk_cnt']++;
    };

    if(cont !== undefined)
        STATE_CONTS.push(cont);

    console.log("build_hls_cont: CONTS=" + JSON.stringify(STATE_CONTS));
};

function compose_hls_chunk_path(rec)
{
    var trg = new Date(0);
    trg.setUTCSeconds(rec.timestamp);

//    console.log('compose_hls_chunk_path: rec.timestamp=' + rec.timestamp + ', rec.filename=' + rec.filename);

    var path =
         CONFIG[STATE_CHANNEL_ID].lib + '/' +
        ("000" + trg.getUTCFullYear()).slice(-4) + '/' +
        ("00" + (1 + trg.getUTCMonth())).slice(-2) + '/' +
        ("00" + trg.getUTCDate()).slice(-2) + '/' +
        ("00" + trg.getUTCHours()).slice(-2) + '/' +
        rec.filename;

//    console.log('compose_hls_chunk_path: path=' + path);

    return path;
};

function compose_hls_m3u8()
{
    console.log("compose_hls_m3u8: here");

    var playlist =
        "#EXTM3U\n" +
        "#EXT-X-VERSION:3\n" +
        "#EXT-X-TARGETDURATION:6\n" +
        "#EXT-X-MEDIA-SEQUENCE:0\n" +
        "#EXT-X-PLAYLIST-TYPE:VOD\n";

    STATE_CHUNKS.forEach(function(rec) {
        playlist += "#EXT-X-DISCONTINUITY\n";
        playlist += "#EXTINF:" + (rec.ts_dur / 90000.0)  + "\n"
        playlist += compose_hls_chunk_path(rec) + "\n";
    });

    playlist += "#EXT-X-ENDLIST\n";

    return playlist;
}

function setup_hls_player()
{
    if(Hls.isSupported())
    {
        var video = document.getElementById('main_video');
        var hls = new Hls({pLoader: pLoader,});
        hls.attachMedia(video);

        $('#main_video').prop("volume", 0.1);

        video.addEventListener("timeupdate", ev_seektimeupdate, false);
        video.addEventListener("seeked", ev_seeked, false);
        video.addEventListener("seeking", ev_seeking, false);

        hls.on(Hls.Events.MANIFEST_PARSED, function()
        {
            console.log("setup_hls_player: Hls.Events.MANIFEST_PARSED");
            $(".timeline_body").live_history_timeline('seek_to', time_video2day(video.currentTime));
            set_display_time(time_video2day(video.currentTime));
//            video.currentTime += 0.1;
        });

        // load dummy into hls
        hls.loadSource("config.json");

        // save hls
        STATE_HLS = hls;
    };
};

class pLoader extends Hls.DefaultConfig.loader
{
    constructor(config)
    {
        super(config);
        var load = this.load.bind(this);
        this.load = function(context, config, callbacks)
        {
            if(context.type == 'manifest')
            {
                var onSuccess = callbacks.onSuccess;
                callbacks.onSuccess = function(response, stats, context)
                {
                    response.data = compose_hls_m3u8();
                    onSuccess(response, stats, context);
                }
            }
            load(context,config,callbacks);
        };
    }
}

function ev_seeked()
{
////    console.log("seeked");
    var video = document.getElementById('main_video');
    $(".timeline_body").live_history_timeline('seek_to', time_video2day(video.currentTime));
    set_display_time(time_video2day(video.currentTime));

//    $('#control_buttons').find('button.nav_ctl').each(function(index)
//    {
//        $(this).prop("disabled", false);
//    });
};

function ev_seeking()
{
////    console.log("seeking....");

//    $('#control_buttons').find('button.nav_ctl').each(function(index)
//    {
//        $(this).prop("disabled", true);
//    });
};

function ev_seektimeupdate()
{
////    console.log("seektimeupdate....");
    var video = document.getElementById('main_video');
    $(".timeline_body").live_history_timeline('seek_to', time_video2day(video.currentTime));
    set_display_time(time_video2day(video.currentTime));
};


function parse_chunk_data(data)
{
    var r = [];

    data.split("\n").forEach(function(line)
    {
        /* skip empty lines */
        if(line.length == 0)
            return;

        var attrs = line.split("\t");

        if(attrs.length != 4)
            return;

        var i = {};

        i['filename'] = attrs[0];
        i['timestamp'] = parseInt(attrs[1], 10);
        i['ts_dur'] = parseInt(attrs[2], 10);
        i['ts_start'] = parseInt(attrs[3], 10);

        r.push(i);
    });

    return r;
};

function setup_timeline(timestamp_ms)
{
    $(".timeline_body").live_history_timeline('setup');
};

function process_chunk_data(timestamp_ms)
{
    console.log('process_chunk_data: finished, found ' + STATE_CHUNKS.length);
    console.log('process_chunk_data: timestamp_ms=' + timestamp_ms);

    if(STATE_CHUNKS.length)
    {
        console.log('process_chunk_data: timestamp=' + STATE_CHUNKS[0].timestamp);

        build_hls_cont(timestamp_ms);
        setup_timeline(timestamp_ms);
        setup_hls_player();
    };
};

function lib_path(timestamp_ms)
{
    var trg = new Date(timestamp_ms);

    var path = CONFIG[STATE_CHANNEL_ID].lib + '/' +
        ("000" + trg.getUTCFullYear()).slice(-4) + '/' +
        ("00" + (1 + trg.getUTCMonth())).slice(-2) + '/' +
        ("00" + trg.getUTCDate()).slice(-2) + '/' +
        ("00" + trg.getUTCHours()).slice(-2);

    return path;
};

function load_chunk_data(timestamp_ms, add_hours)
{
    if(add_hours == 24)
    {
        // finished loading
        process_chunk_data(timestamp_ms);
        return;
    };

    var url = lib_path(timestamp_ms + add_hours * 3600 * 1000) + '/index.cvs';

    console.log('load_chunk_data: url=[' + url + ']');

    var jqxhr = $.get(url, function(data) {
         STATE_CHUNKS = STATE_CHUNKS.concat(parse_chunk_data(data));
    })
    .done(function() {
//        alert( "second success" );
    })
    .fail(function() {
        console.log('load_chunk_data: failed to load');
    })
    .always(function() {
        load_chunk_data(timestamp_ms, add_hours + 1)
    });
};

function reload_channel_day()
{
    console.log('reload_channel_day: STATE_CHANNEL_ID=[' + STATE_CHANNEL_ID + '], STATE_DATE=[' + STATE_DATE + ']');
    window.location.hash = STATE_CHANNEL_ID + "@" + STATE_DATE;

    var yyyymmdd = STATE_DATE.match(/(\d{4})-(\d{2})-(\d{2})/);

    console.log('reload_channel_day: yyyymmdd[1]=[' + yyyymmdd[1] + '], yyyymmdd[2]=[' + yyyymmdd[2] + '], yyyymmdd[2]=[' + yyyymmdd[3] + '],');

    var timestamp_ms = Date.UTC(yyyymmdd[1], yyyymmdd[2] - 1, yyyymmdd[3])
        - 1000 * 3600 * CONFIG[STATE_CHANNEL_ID].tz;

    console.log('reload_channel_day: timestamp_ms=[' + timestamp_ms + '], i.e :' + new Date(timestamp_ms));

    // reset timeline
    $(".timeline_body").live_history_timeline('reset');

    // destroy hls player
    if(STATE_HLS !== undefined)
    {
        STATE_HLS.destroy();
        STATE_HLS = undefined;
    };

    // reset date chunks
    STATE_CHUNKS = [];

    // destrou timeline
    $(".timeline_body").live_history_timeline('reset');

    // reset continious regeions
    STATE_CONTS = [];

    // start loading chunks data
    load_chunk_data(timestamp_ms, 0);

    // save timestamp_ms for future
    STATE_TIMESTAMP_MS = timestamp_ms;
}

function load_config()
{
    var page_holder_top = $('.page_holder_top');

    console.log("Loading config...");

    page_holder_top.text("Loading config...");

    $.getJSON
    (
        'config.json',
        {
        }
    )
    .done(function(config)
    {
        /* save config */
        CONFIG = config;

        /* build page header */
        page_holder_top.empty();

        /* add dropbox for channel changing */
        var channel_picker = $('<select id="channel_picker"></select>');
        channel_picker.appendTo(page_holder_top);
        for (var channel_id in CONFIG) {
            console.log('channel_id=' + channel_id);

            var option = $('<option></option');
            option.text(CONFIG[channel_id].title);
            option.attr('value', channel_id);
            option.appendTo(channel_picker);
        }
        channel_picker.change(() => {
            console.log('Channel changed');
            var channel_id;
            channel_picker.find('option:selected').each(function() {
                channel_id = $(this).attr('value');
            });
            console.log('Channel changed to: ' + channel_id);
            STATE_CHANNEL_ID = channel_id;
            reload_channel_day();
        });

        /* calendar create */
        var date_picker = $("<div id='date_picker' class='date_picker'><button class='date_picker'></button></div>");
        date_picker.appendTo(page_holder_top);
        date_picker.find('button.date_picker').text('detecting...');
        date_picker.delegate("button.date_picker", "click", function()
        {
            console.log("date_picker called");
            calendar_show(STATE_DATE, function(new_date){
                console.log("date_picker: new_date=" + new_date);
                STATE_DATE = new_date;
                date_picker.find('button.date_picker').text(new_date);
                reload_channel_day();
            });
        });

        /* detect and parse current selected channel@date */
        var hash = window.location.hash;
        console.log("HASH=" + hash);
        if("" != hash)
        {
            var args = hash.split("@");
            if(undefined !== args && args instanceof Array && args.length == 2)
            {
                STATE_CHANNEL_ID = args[0];
                if('#' == STATE_CHANNEL_ID.charAt(0))
                    STATE_CHANNEL_ID = STATE_CHANNEL_ID.substr(1);
                STATE_DATE = args[1];
                if(null == STATE_DATE.match(/(\d{4})-(\d{2})-(\d{2})/))
                    STATE_DATE = undefined;
            };
        };

        /* check if that STATE_ is correct */
        if(STATE_DATE === undefined)
            STATE_DATE = calendar_today_str();
        if(undefined === CONFIG[STATE_CHANNEL_ID])
        {
            for (var channel_id in CONFIG) {
                STATE_CHANNEL_ID = channel_id;
                break;
            };
        };

        /* set active selection */
        date_picker.find('button.date_picker').text(STATE_DATE);
        channel_picker.find('option').each(function() {
            $(this).attr('selected', null);
        });
        channel_picker.find('option').each(function() {
            if($(this).attr('value') == STATE_CHANNEL_ID)
                $(this).attr('selected', 'selected');
        });

        /* and finally reload it */
        reload_channel_day();

        /* setup key control binding */
        $(".page_holder_bottom_timeline").attr('tabindex', 0);
        $(".page_holder_bottom_timeline").on('keydown', function(ev)
        {
////            console.log('keydown=' + ev.which);

            if(!STATE_HLS)
                return;

            var video = document.getElementById('main_video');

            if(ev.which == 32)
            {
                if(video.paused)
                    video.play();
                else
                    video.pause();
            }
            else if(ev.which == 39)
                video.currentTime += 1.0;
            else if(ev.which == 37)
                video.currentTime -= 1.0;
            else if(ev.which == 38)
                video.currentTime -= 10.0;
            else if(ev.which == 40)
                video.currentTime += 10.0;
            else if(ev.which == 33)
                video.currentTime -= 60.0;
            else if(ev.which == 34)
                video.currentTime += 60.0;


            ev.preventDefault();
            return true;
        });
    })
    .fail(function( jqxhr, textStatus, error )
    {
        var err = textStatus + ", " + error;
        console.log( "Config load failed: " + err );
        $('.page_holder_top').text(err);
    });
};

function live_history_timeline_seek_cb(tm)
{
    console.log('live_history_timeline_seek_cb: ' + tm);

    var video = document.getElementById('main_video');
    video.currentTime = time_day2video(tm);
};

function live_history_timeline_thumb_url_cb(t)
{
    var start = STATE_TIMESTAMP_MS / 1000;

////    console.log('live_history_timeline_thumb_url_cb: t=' + t + ', start=' + start);
////    console.log('live_history_timeline_thumb_url_cb: [0]=' + JSON.stringify(STATE_CHUNKS[0]));

    for(var i = 0; i < STATE_CHUNKS.length; i++)
    {
        var Bi = STATE_CHUNKS[i].timestamp - start;

//        console.log('live_history_timeline_thumb_url_cb: Bi=' + Bi);

        if(t < Bi)
            break;

        var Ei = Bi + STATE_CHUNKS[i].ts_dur / 90000;

//        console.log('live_history_timeline_thumb_url_cb: Ei=' + Ei);

        if(t > Ei)
            continue;

        var img = STATE_CHUNKS[i].filename.replace(/ts/g, 'jpg');

////console.log('t=' + t + ', Bi=' + Bi + ', Ei=' + Ei + 'timestamp=' + STATE_CHUNKS[i].timestamp);

        var url = lib_path(STATE_CHUNKS[i].timestamp * 1000) + '/' + img;

//        console.log('live_history_timeline_thumb_url_cb: url=' + url);

        return url;
    };

    return null;
};

function time_video2day(t)
{
    var i, a, r;

    for(a = 0, i = 0; i < STATE_CONTS.length; i++)
    {
        var d = STATE_CONTS[i].ts_dur / 90000;
        var o = STATE_CONTS[i].offset;

        if(t < (a + d))
        {
            r = o + t - a;
////            console.log('time_video2day: ' + t + ' => ' + r);
            return r;
        };

        a += d;
    };

    console.log('time_video2day: ERROR t=' + t);
    return t;
};

function time_day2video(t)
{
    var i, a, r;

    for(a = 0, i = 0; i < STATE_CONTS.length; i++)
    {
        var d = STATE_CONTS[i].ts_dur / 90000;
        var o = STATE_CONTS[i].offset;

        if(t < o)
        {
////            console.log('time_day2video: ' + t + ' => ' + a);
            return a;
        };

        if(t < (o + d))
        {
            r = a + t - o;
////            console.log('time_day2video: ' + t + ' => ' + r);
            return r;
        };

        a += d;
    };

    return a - 0.5;
};

function  set_display_time(t)
{
    var sec = Math.trunc(t);

    var ms = ("000" + Math.trunc((t - sec) * 10)).slice(-1);
    var ss = sec % 60; sec = Math.trunc(sec / 60);
    var mm = sec % 60; sec = Math.trunc(sec / 60);
    var hh = sec % 24;

    t =
        ("00" + hh).slice(-2) + ":" +
        ("00" + mm).slice(-2) + ":" +
        ("00" + ss).slice(-2) + "." + ms;

    $(".page_holder_bottom_timings").text(t);
};

function live_history_timeline_cont_region_rem_cb(t)
{
    var i;

    for(a = 0, i = 0; i < STATE_CONTS.length; i++)
    {
        var b = STATE_CONTS[i].offset;
        var e = b + STATE_CONTS[i].ts_dur / 90000;

        if(b <= t && t < e)
            return (e - t);
    };

    return 0;
};

$(document).ready(function()
{
    $(".timeline_body").live_history_timeline
    ({
        'cont_region_rem_cb' : live_history_timeline_cont_region_rem_cb,
        'seek_cb' : live_history_timeline_seek_cb,
        'thumb_url_cb' : live_history_timeline_thumb_url_cb
    });

    $('.export_control_area').hide();
    $('button.export_control.hide').hide();
    $('button.export_control').on('click', function() {
        var w, w_vis = 300, w_hid = 30;

        if($(this).hasClass('hide'))
        {
            w = w_hid;
            $('button.export_control.hide').hide();
            $('button.export_control.show').show();
            $('.export_control_area').hide();
        }
        else
        {
            w = w_vis;
            $('button.export_control.show').hide();
            $('button.export_control.hide').show();
            $('.export_control_area').show();
        };

        $('.page_holder_right').css({'width' : w});
        $('.page_holder_center').css({'right' : w});
        $('.page_holder_bottom').css({'right' : w});
    });

    $('.page_holder_bottom_controls').delegate("button.video_control", "click", function()
    {
        if(!STATE_HLS)
            return;

        var video = document.getElementById('main_video');

        if($(this).hasClass('play'))
            video.play();
        else if($(this).hasClass('pause'))
            video.pause();
    });

    load_config();
});
