function modal_dialog_window_open(conf)
{
    //Get the screen height and width
    var maskHeight = $(document).height();
    var maskWidth = $(window).width();

    var mask_div = $("<div></div>");
    $("body").append(mask_div);
    mask_div.addClass(conf['mask_class']);
    mask_div.css
    ({
        'position': 'fixed',
        'top': '0px',
        'left': '0px',
        'z-index': '9000',
        'width' : maskWidth,
        'height' : maskHeight
    });
    conf['mask_div'] = mask_div;

    /* block scrolls and clicks */
    mask_div.on('click', function(e) { e.preventDefault(); return true; });
    mask_div.on('mousewheel', function(e) { e.preventDefault(); return true; });
    mask_div.on('scroll', function(e) { e.preventDefault(); return true; });

    var wnd_div = $("<div></div>");
    $("body").append(wnd_div);
    wnd_div.addClass(conf['wnd_class']);

    var
        t = ($(window).height() - wnd_div.outerHeight()) / 2,
        l = ($(window).width() - wnd_div.outerWidth()) / 2;

    wnd_div.css
    ({
        'position': 'fixed',
        'top': Math.round(t) + 'px',
        'left': Math.round(l) + 'px',
        'z-index': '9001'
    });
    conf['wnd_div'] = wnd_div;

    /* run callback function */
    conf['proc'](wnd_div, conf, conf['cookie']);
};

function modal_dialog_window_close(conf)
{
    conf['wnd_div'].remove();
    conf['mask_div'].remove();
};
