function miniajax(url, props, callback)
{
    var busy = 0;
    var req = init();
    req.onreadystatechange = processRequest;

    function init()
    {
        if (window.XMLHttpRequest)
        {
            return new XMLHttpRequest();
        }
        else if (window.ActiveXObject)
        {
            return new ActiveXObject("Microsoft.XMLHTTP");
        }
    }

    function processRequest ()
    {
        if (req.readyState == 4)
        {
            if (req.status == 200)
            {
                if (callback)
                {
                    var h = new Array();
                    var doc = req.responseXML.documentElement;
                    for(i = 0; i < props.length; i++)
                    {
                        var name = props[i];
                        h[name] = '';
                        var child = doc.getElementsByTagName(name)[0].firstChild;
                        if(child)
                            h[name] = child.data;
                    };
                    callback(h);
                    busy = 0;
                };
            }

        }
    }

    this.doGet = function()
    {
        if(busy)
        {
            busy++;
            if(busy > 20)
            {
                req.abort();
                busy = 0;
//                alert('resetted');
            };
            return;
        };
        busy = 1;
        req.open("GET", url, true);
        req.send(null);
    }

    this.doPost = function(body)
    {
        if(busy)
        {
            busy++;
            if(busy > 20)
            {
                req.abort();
                busy = 0;
//                alert('resetted');
            };
            return;
        };
        busy = 1;
        req.open("POST", url, true);
        req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        req.send(body);
    }
}
