<?php

include_once 'XML/RPC2/Client.php';

XML_RPC2_Backend::setBackend('php');

$client = XML_RPC2_Client::create('http://127.0.0.1:' . $_REQUEST['xmlrpc_port'] . '/RPC2' ,
    array('prefix' => 'TheCoreElementsFlash.'));

try
{
    if($_REQUEST['args'] == NULL)
        $r = $client->LoadImage($_REQUEST['image']);
    else
    {
        $data = json_decode($_REQUEST['args'], true);
        $args = array();
        error_log("----");
        foreach($data as $key => $value)
        {
            error_log("key=[$key], val=[$value]");
            $args[$key] = $value;
        };
        $r = $client->LoadImage($_REQUEST['image'], new XML_RPC2_Backend_Php_Value_Struct($args));
    };
}
catch (XML_RPC2_FaultException $e)
{
    $r = array
    (
        'faultString'     => $e->getFaultString(),
        'faultCode'     => $e->getFaultCode(),
    );
}
catch (Exception $e)
{
    $r = array
    (
        'faultMessage'     => $e->getMessage()
    );
}

header("Content-type: text/x-json");
echo json_encode($r);
