$.fn.TheCoreElementsSubsIns_attach = function(params)
{
    var p;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsSubsIns main"></div>');
    main_div.appendTo(parent_div);

    // -------------------------

    $('<div class="TheCoreElementsSubsIns row"><h1>Connection</h1></div>').appendTo(main_div);

    function append_row(title, type, conn_output)
    {
        var row = $('<div class="TheCoreElementsSubsIns row"></div>');
        row.appendTo(main_div);

        var t = $('<span class="title"></span');
        t.appendTo(row);
        t.text(title);

        var td_sel = $('<select class="CONN"></select>');
        td_sel.prop('disabled', true);
        td_sel.appendTo(row);
        td_sel.addClass(type);
        if(conn_output)
            td_sel.addClass('CONN_OUTPUT');

        row.delegate('select.CONN', 'change', function(e)
        {
            console.log('Input changed');
            main_div.find('button.SAVE_CONN').prop('disabled', false);
        });
    };

    append_row('Input:', 'INP', 0);
    append_row('Output:', 'OUT', 1);

    $('<div class="TheCoreElementsSubsIns row"><button class="SAVE_CONN"> SAVE </button></div>').appendTo(main_div);

    main_div.delegate('button.SAVE_CONN', "click", function()
    {
        var conn =
        {
            "inp": 0,
            "out": 0,
        };

        main_div.find('select.CONN').each(function(index)
        {
            var c = parseInt($(this).val());
            if($(this).hasClass('INP')) conn['inp'] = c;
            else if($(this).hasClass('OUT')) conn['out'] = c;
            else if($(this).hasClass('AUX')) conn['aux'] = c;
        });

        console.log("saving connections...conn=" + JSON.stringify(conn));

        var r =
        {
            'xmlrpc_port'       : params['port'],
            'conn'              : conn,
        };

        $.post
        (
            'TheCoreElementsSubsIns.SetConnections.php', r
        )
        .done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });

    // -------------------------

    $('<div class="TheCoreElementsSubsIns row"><h1>Functions</h1></div>').appendTo(main_div);

    $('<div class="TheCoreElementsSubsIns row"><h2><input type="radio" class="row FLAG_SWITCH" name="func_selector" value="0">NONE</h2></div>').appendTo(main_div);

    $('<div class="TheCoreElementsSubsIns row"><h2><input type="radio" class="row FLAG_SWITCH" name="func_selector" value="1">TEST DATA</h2></div>').appendTo(main_div);

    $('<div class="TheCoreElementsSubsIns row"><h2><input type="radio" class="row FLAG_SWITCH" name="func_selector" value="2">INSERTOR</h2></div>').appendTo(main_div);

    // -------------------------

    main_div.delegate('input[type="radio"][name="func_selector"].row.FLAG_SWITCH', "change", function()
    {
        var val = $(this).val();

        main_div.find('input[type="radio"][name="func_selector"].row.FLAG_SWITCH').prop('disabled', true);

        console.log('check box changed, val=' + val);

        $.post('TheCoreElementsSubsIns.SetFunction.php', { 'xmlrpc_port' : params['port'], 'value' : val } ).done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });


    // -------------------------

    $('<div class="TheCoreElementsSubsIns row"><h1>Insertor config</h1></div>').appendTo(main_div);

    function append_ins_config_row(idx)
    {
        var row = $('<div class="TheCoreElementsSubsIns row INSERTOR"></div>');
        row.appendTo(main_div);
        row.attr('idx', idx);

        var p = $('<input type="text" class="TheCoreElementsSubsIns INSERTOR INSERTOR_PAGE_NO">');
        p.appendTo(row);

        var s = $('<input type="text" class="TheCoreElementsSubsIns INSERTOR INSERTOR_SUFF">');
        s.appendTo(row);

        row.delegate('input.INSERTOR', 'keypress', function(e)
        {
            main_div.find('button.SAVE_INS').prop('disabled', false);
        });
    };

    $('<div class="TheCoreElementsSubsIns row"><div class="TheCoreElementsSubsIns INSERTOR_PAGE_NO">PAGE NO</div><div class="TheCoreElementsSubsIns INSERTOR_SUFF">SUFFIX</div>').appendTo(main_div);

    for(i = 0; i < 8; i++)
        append_ins_config_row(i);

    $('<div class="TheCoreElementsSubsIns row"><button class="SAVE_INS"> SAVE </button></div>').appendTo(main_div);

    // -------------------------

    main_div.delegate('button.SAVE_INS', "click", function()
    {
        var suffs = [ "", "", "", "",  "", "", "", ""];
        var pages = [ "", "", "", "",  "", "", "", ""];

        main_div.find('div.TheCoreElementsSubsIns.row.INSERTOR').each(function(index)
        {
            var idx = parseInt($(this).attr('idx'));

            suffs[idx] = $(this).find('input.INSERTOR.INSERTOR_SUFF').val();
            pages[idx] = $(this).find('input.INSERTOR.INSERTOR_PAGE_NO').val();
        });

        console.log("saving insertor...suffs=" + JSON.stringify(suffs) + ", pages=" + JSON.stringify(pages));

        var r =
        {
            'xmlrpc_port'       : params['port'],
            'suffs'             : suffs,
            'pages'             : pages,
        };

        $.post
        (
            'TheCoreElementsSubsIns.SetInsertor.php', r
        )
        .done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });


    //

    parent_div.delegate("input[type='text'].row_pos", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            return false;
        }
    });

    parent_div.delegate("input[type='text'].row_neg", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            if(txt != '-')
                return false;
        }
    });

    function GetStat()
    {
        $.getJSON
        (
            'TheCoreElementsSubsIns.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));
            update_ui(curr);
        })
        .fail(function(msg)
        {
        });
    };

    GetStat();


    function update_ui_labels(curr, labels, type, matrix_output)
    {
        var opt;
        var sel_idx;
        var td_sel = main_div.find('select.CONN.' + type);

        /* disable */
        td_sel.prop('disabled', true);

        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        opt = $('<optgroup label="Outputs"></optgroup>');
        opt.appendTo(td_sel);

        if(!td_sel.hasClass('CONN_OUTPUT'))
        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
        {
            if("" == labels.outputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(sel_idx);
            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
            if(sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        opt = $('<optgroup label="Inputs"></optgroup>');
        opt.appendTo(td_sel);

        for(sel_idx = 1; sel_idx < labels.inputs.length; sel_idx++)
        {
            if("" == labels.inputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(-sel_idx);
            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
            if(-sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        /* enable */
        td_sel.prop('disabled', false);
    };

    function update_ui(curr)
    {
        /* update connections labels */
        $.getJSON
        (
            'TheCoreElementsSubsIns.GetLabels.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(labels)
        {
            console.log("GetLabels:" + JSON.stringify(labels));

            update_ui_labels(curr, labels, 'INP', curr.inp);
            update_ui_labels(curr, labels, 'OUT', curr.out);

            main_div.find('button.SAVE_CONN').prop('disabled', true);

            $('input[type="radio"][name="func_selector"].row.FLAG_SWITCH')[parseInt(curr.func)].checked = true;
            main_div.find('input[type="radio"][name="func_selector"].row.FLAG_SWITCH').prop('disabled', false);


            main_div.find('button.SAVE_INS').prop('disabled', true);

            main_div.find('div.TheCoreElementsSubsIns.row.INSERTOR').each(function(index)
            {
                var idx = parseInt($(this).attr('idx'));

                $(this).find('input.INSERTOR.INSERTOR_SUFF').val(curr.suffs[idx]);
                $(this).find('input.INSERTOR.INSERTOR_PAGE_NO').val(curr.pages[idx]);
            });

        })
        .fail(function(msg)
        {
        });
    };
}
