<?php

    $r = [];
    $T = time();

    $bumper = ($_REQUEST['bumper'] == '1') ? 1 : 0;

    /* source m3u8 name */
    $src_m3u8 = __DIR__ . '/hls/' . $_REQUEST['id'] . '/index.m3u8';

    /* load m3u8 and append EXT-X-ENDLIST */
    $lines = file($src_m3u8, FILE_IGNORE_NEW_LINES);
    foreach($lines as &$l)
    {
        if('#' != substr($l, 0, 1))
            $l = dirname($src_m3u8) . '/' . $l;
    };
    $lines[] = '#EXT-X-ENDLIST';

    /* destination m3u8 name */
    $dst_m3u8 = __DIR__ . '/tmp/' . $T . '.m3u8';

    /* save updated m3u8 */
    file_put_contents($dst_m3u8, join($lines, PHP_EOL));

    /* args array */
    $args = array();
    $args[] = '/usr/local/enctools/bin/ffmpeg';
//    $args[] = '-noaccurate_seek';
    $args[] = '-ss';
    $args[] = $_REQUEST['mark_in'];
//    $args[] = '-live_start_index';
//    $args[] = '0';
    $args[] = '-i';
    $args[] = $dst_m3u8;
    $args[] = '-t';
    $args[] = floatval($_REQUEST['mark_out']) - floatval($_REQUEST['mark_in']);
    $args[] = '-acodec';
    $args[] = 'copy';
    $args[] = '-vcodec';
    $args[] = 'copy';
    $args[] = '-f';
    if($_REQUEST['format'] == 'mp4' && !$bumper)
    {
        $args[] = 'mp4';
        $args[] = '-movflags';
        $args[] = '+faststart';

        $t = 'tmp/' . $T . '.mp4';
    }
    else
    {
        $args[] = 'mpegts';
        $t = 'tmp/' . $T . '.ts';
    };

    $args[] = '-avoid_negative_ts';
    $args[] = 'make_zero';

    $args[] = '-y';
    $args[] = __DIR__ . '/' . $t;

    $cmd = join(' ', $args);

    exec($cmd);

    if($bumper)
    {
        $args = array();
        $args[] = '/usr/local/enctools/bin/ffmpeg';
        $args[] = '-i';
        $args[] = '"concat:' . (__DIR__ . '/tmp/BUMP_IN.ts') . '|' . (__DIR__ . '/' . $t) . '|' . (__DIR__ . '/tmp/BUMP_OUT.ts') . '"';
        $args[] = '-acodec';
        $args[] = 'copy';
        $args[] = '-vcodec';
        $args[] = 'copy';
        $args[] = '-f';
        $args[] = 'mp4';
        $args[] = '-movflags';
        $args[] = '+faststart';

        $t = 'tmp/' . $T . '.mp4';

        $args[] = '-y';
        $args[] = __DIR__ . '/' . $t;

        $cmd = join(' ', $args);

        exec($cmd);
    };

    $r['target'] = $t;
    $r['cmd'] = $cmd;

    header("Content-type: text/x-json");
    echo json_encode($r);
?>